#!/usr/bin/perl -w

use strict;

use Net::Blogger;

use Data::Dumper;

use Carp;

my $mt = Net::Blogger->new(
	engine => "movabletype"
);

# set our proxy (the URL of our XML-RPC server)
$mt->Proxy("http://www.multiply.org/mt/mt-xmlrpc.cgi");

# replace with your username and password
$mt->Username("jason gessner");
$mt->Password("****");

# ask the user what blog to use
$mt->BlogId(&prompt_for_blog_id());

# ask the user for their post
my $post = &prompt_for_entry_text();

# ok, now we have all the info we need to post this text
my $post_id = $mt->newPost(
	postbody => \$post,
	publish => 0
) || croak $mt->LastError();

print "\nThe post id is $post_id\n";

sub prompt_for_blog_id() {
	# get a list of the blogs for the specified user/pass
	my $bloglist = $mt->getUsersBlogs()
	   || croak $mt->LastError();

	  
	# print out the details of each blog with a prompt
	print "Please choose which blog you would like to post to:\n";
	print "---------------------------------------------------\n";

	# make a hash of our user's blogs so we can verify the input
	# without a loop
	my %blogs;

	# since this returns an array ref of hashes, we need 
	# to dereference our bloglist before cycling through it.
	for my $blog (@{ $bloglist } ) {
		print $blog->{ 'blogid' }, ") ", $blog->{ 'blogName' }, "\n", 
			"\t", $blog->{ 'url' }, "\n";
		# stash this id
		$blogs{ $blog->{ 'blogid' } }++;
	}

	my $blog_id;

	chomp ($blog_id = <STDIN>);
	while (! $blogs{$blog_id} ) {
		print "Please choose a valid blog id (see list above)\n";
		chomp ($blog_id = <STDIN>);
	}

	return $blog_id;
}

sub prompt_for_entry_text() {
	print "Please enter the text for your post:\n";
	print "\t--- end your post with period alone on a line\n";

	my $input;

	while (<>) {
		chomp ($_);
		$input .= "$_\n";

		last if ($_ eq ".");
	}

	return $input;
}
