#!/usr/local/bin/perl -w

use MIME::Parser;
use File::Copy;

# for parsing out the address in the From: header
use Mail::Address;

# our DB functions
use KPDB;

# chuck's thumbnail function
use ThumbnailGen;

# for generating temp file names
use Fcntl;
use POSIX qw(tmpnam);

# making sure our text stays all legit, like
use MIME::Words qw(:all);

#------------------------------
#
# dump_entity ENTITY, NAME
#
# Recursive routine for dumping an entity.
#
sub dump_entity {
    my ($entity, $name) = @_;
    defined($name) or $name = "'anonymous'";
    my $IO;

    # Output the head:
    # print "\n", '=' x 60, "\n";
    # print "Message $name: ";
    # print "\n", '=' x 60, "\n\n";
    # print $entity->head->original_text;
    # print "\n";
    
    my @files;
    
    # Output the body:
    my @parts = $entity->parts;
    if (@parts) {                     # multipart...
	my $i;
	foreach $i (0 .. $#parts) {       # dump each part...
	    $return = dump_entity($parts[$i], ("$name, part ".(1+$i)));

	    # print "return = $return\n";
	    push @files, $return;
	    
	}
    }
    else {                            # single part...	

	# Get MIME type, and display accordingly...
	my ($type, $subtype) = split('/', $entity->head->mime_type);
	my $body = $entity->bodyhandle;
	# if ($type =~ /^(text|message)$/) {     # text: display it...
	#    if ($IO = $body->open("r")) {
	    # print $_ while (defined($_ = $IO->getline));
	    #	$IO->close;
	    #  }
	    #else {       # d'oh!
		    # print "$0: couldn't find/open '$name': $!";
#	    }
#	}
#	else {                                 # binary: just summarize it...
	    my $path = $body->path;
	    my $size = ($path ? (-s $path) : '???');
	    # print ">>> This is a non-text message, $size bytes long.\n";
	    # print ">>> It is stored in ", ($path ? "'$path'" : 'core'),".\n\n";

	    return $path;
#	}
    }

    return @files;

    1;
}

#------------------------------
#
# main
#
my @files;

sub main {
    print STDERR "(reading from stdin)\n" if (-t STDIN);

    # Create a new MIME parser:
    my $parser = new MIME::Parser;
    
    # Create and set the output directory:
    (-d "/tmp/kpix-mimedump-tmp") or mkdir "/tmp/kpix-mimedump-tmp",0777 or die "mkdir: $!";
    (-w "/tmp/kpix-mimedump-tmp") or die "can't write to directory";
    
    # control our output format
    $parser->output_dir("/tmp/kpix-mimedump-tmp");
    $parser->filer->ignore_filename(1); 
    $parser->output_prefix(time());
    
    # Read the MIME message:
    $entity = $parser->read(\*STDIN) or die "couldn't parse MIME stream";

    # check for from address
    my $from = $entity->head->get('from');
    chomp($from);
   
    my $from_address;
    my @addrs = Mail::Address->parse($from);
    foreach $addr (@addrs) {
	    $from_address = $addr->user . "@" . $addr->host;
    }
   
    # add some error checking for email addresses
    
    # connect to our database
    KPDB->connect();

    if (!KPDB->is_banned($from_address)) {
	# valid sender
	print "Sender not banned!\n";

	# check for valid gateway
	my $lineNum = 1;
	foreach $line ($entity->head->get('received')) {
		if ($lineNum == 1) {
			$gateway .= $line;
		}
		$lineNum++;
	}

	# pull in the subject for later use
	my $subject = decode_mimewords($entity->head->get('subject'));

	print $subject, "\n";
	
	chomp($gateway);
	# print $gateway, "\n";
	
	my ($ehelo,$validname,$validip) = parseReceived($gateway);
	
	# print "$ehelo\t$validname\t$validip\n";
	
	if (KPDB->event_check_gateway($validname)) { 
	
		# add log4perl stuff
		# print "Gateway is valid.\n"; 
		my @newfiles = dump_entity($entity);	
		# only accept messages that have a .txt part and a .jpg part
		if ($#newfiles == 1) {
			print "We have the proper number of files\n";		
		
			my $pic = "";
			my $txt = "";
			foreach $file (@newfiles) {
			# print "\t$file\n";
			# determine what kind of file we have
			# copy files to the destination
			
			# read text file contents into var
			if ($file =~ m/txt$/i) {
				$txt = decode_mimewords(returnFileContents($file));
			} elsif ($file =~ m/jpg$/i) {
				$pic = $file;
			}	
		} # foreach
		
		# insert record into DB & get the ID of the new record
		my $photo_id = KPDB->new_event_photo(1, $from_address, $subject, $txt, 1);
		
		# close up our database connection
		KPDB->disconnect();

		# copy picture over to the dest with the new ID
		$dest_base = "/var/vhosts/www.kpix.jp/eventphotos/";
		$dest = "$photo_id.jpg";
#?		$dest =~ s#(^.*\\)()##;
		# print "\t\t$dest\n";
		copy($pic, "$dest_base$dest");

	
		# generate our thumbnails
		ThumbnailGen->generateThumb("$dest_base$dest", .9, "$dest_base${photo_id}_1.jpg");		
		ThumbnailGen->generateThumb("$dest_base$dest", .4, "$dest_base${photo_id}_2.jpg");
		ThumbnailGen->generateThumb("$dest_base$dest", .2, "$dest_base${photo_id}_3.jpg");
		ThumbnailGen->generateThumb("$dest_base$dest", .1, "$dest_base${photo_id}_4.jpg");	
	
		} # proper number of files 
	} else {
		# add a listing to our new_gateway table
		KPDB->event_add_new_gateway($validname, $from_address);

		# invalid gateway, so exit
		print "Mail from unauthorized gateway.\n";
	}
    } else {
	# invalid sender
	print $from, " is not allowed to send me mail.\n";
    }
    
    # clean up our mess
    $parser->filer->purge;
    
}

sub replace_filename() {
	# replace our base filename, but leave the extension intact
	my ($filename, $new_base) = @_;

	$filename =~ s/(.*)(\..*)$/$new_base$2/i;

	return $filename;
}

sub parseReceived() {
    my $line = shift;

    # "normal" -- from HELO (REAL [IP])
    if ($line =~ m/from\s+(\w\S+)\s*\((\S+)\s*\[(\d+\.\d+\.\d+\.\d+)/){
      ($ehelo,$validname,$validip) = ($1,$2, $3);
    }
    # can't reverse resolve -- from HELO ([IP])
    elsif ($line =~ m/from\s+(\w\S+)\s+\(\[(\d+\.\d+\.\d+\.\d+)\]/){
      ($ehelo,$validname,$validip) = ($1,undef, $2);
    }	
    # exim -- from [IP] (helo=[HELO IP])
    elsif ($line =~ m/from\s+\[(\d+\.\d+\.\d+\.\d+)\]\s+\(helo=\[(\d+\.\d+\.\d+\.\d+)\]/){
      ($validip,$ehelo,$validname) = ($1,$2, undef);
    }	
    # Sun Internet Mail Server -- from [IP] by HELO
    elsif ($line =~ m/from\s+\[(\d+\.\d+\.\d+\.\d+)\]\s+by\s+(\S+)/){
      ($validip,$ehelo,$validname) = ($1,$2, undef);
    }	
    # Microsoft SMTPSVC -- from HELO - (IP)
    elsif ($line =~ m/from\s+(\S+)\s+-\s+(\d+\.\d+\.\d+\.\d+)\s+/){
      ($ehelo,$validname,$validip) = ($1,$2, $3);
    }
    else { # punt!
      $ehelo = $validname = $validip = undef;
    }

    return ($ehelo,$validname,$validip);
}


sub returnFileContents() {
	my $contents = "";
	
	my ($filename) = @_;

	open (FILE, $filename) ||
		return undef;

	while (<FILE>) {
		$contents .= $_;	
	}
		
	close(FILE);

	return $contents;
}

exit(&main ? 0 : -1);

#------------------------------
1;

