#!/usr/bin/perl -w

use strict;

use Net::Blogger;

use Data::Dumper;

use Carp;

my $mt = Net::Blogger->new(
	engine => "movabletype"
);

# set our proxy (the URL of our XML-RPC server)
$mt->Proxy("http://www.multiply.org/mt/mt-xmlrpc.cgi");

# replace with your username and password
$mt->Username("command line jason");
$mt->Password("***");

# ask the user what blog to use
$mt->BlogId(&prompt_for_blog_id());

# ask the user for the title of their post
my $title = &prompt_for_entry_title();

# ask the user for their post
my $post = &prompt_for_entry_text();

# ask the user for the category to assign this post to
my $category_id = &prompt_for_category_id();
# TODO: add ability to prompt for multiple categories
my %category_hash;
$category_hash{categoryId} = $category_id;
$category_hash{isPrimary} = 1;
my @category_list = (\%category_hash);


# ok, now we have all the info we need to post this text
my $post_id = $mt->metaWeblog()->newPost(
	title => $title,
	description => $post,
	publish => 0
) || croak $mt->LastError();

print "\nThe post id is $post_id\n";

# now assign the category for the post
$mt->mt()->setPostCategories(
	postid => $post_id, 
	categories => \@category_list
) || croak $mt->LastError();

$mt->mt()->publishPost($post_id);
	
sub prompt_for_blog_id() {
	# get a list of the blogs for the specified user/pass
	my $bloglist = $mt->getUsersBlogs()
	   || croak $mt->LastError();

	  
	# print out the details of each blog with a prompt
	print "Please choose which blog you would like to post to:\n";
	print "---------------------------------------------------\n";

	# make a hash of our user's blogs so we can verify the input
	# without a loop
	my %blogs;

	# since this returns an array ref of hashes, we need 
	# to dereference our bloglist before cycling through it.
	for my $blog (@{ $bloglist } ) {
		print $blog->{ 'blogid' }, ") ", $blog->{ 'blogName' }, "\n", 
			"\t", $blog->{ 'url' }, "\n";
		# stash this id
		$blogs{ $blog->{ 'blogid' } }++;
	}

	my $blog_id;

	chomp ($blog_id = <STDIN>);
	while (! $blogs{$blog_id} ) {
		print "Please choose a valid blog id (see list above)\n";
		chomp ($blog_id = <STDIN>);
	}

	return $blog_id;
}

sub prompt_for_category_id() {
	# get a list of the blogs for the specified user/pass
	my $categorylist = $mt->mt()->getCategoryList()
	   || croak $mt->LastError();

	# print out the list of categories with a prompt
	print "Please choose which category to assign this post to:\n";
	print "\t(simply hit ENTER for no category)\n";
	print "---------------------------------------------------\n";

	# make a hash of our user's blogs so we can verify the input
	# without a loop
	my %categories;

	# since this returns an array ref of hashes, we need 
	# to dereference our bloglist before cycling through it.
	for my $category (@{ $categorylist } ) {
		print $category->{ 'categoryId' }, ")\t", $category->{ 'categoryName' }, "\n";
		# stash this id
		$categories{ $category->{ 'categoryId' } }++;
	}

	my $category_id;

	chomp ($category_id = <STDIN>);
	while (! $categories{$category_id} ) {
		print "Please choose a valid category id (see list above)\n";
		chomp ($category_id = <STDIN>);
	}

	return $category_id;
}

sub prompt_for_entry_text() {
	print "Please enter the text for your post:\n";
	print "\t--- end your post with period alone on a line\n";

	my $input;
	while (<>) {
		chomp ($_);
		last if ($_ eq ".");

		# append to our entry body
		$input .= "$_\n";
	}

	return $input;
}

sub prompt_for_entry_title() {
	print "Please enter the title for your post:\n";
	my $title;
	chomp ($title = <STDIN>);
	return $title;
}
