use WWW::Mechanize;

# a small rewrite of the WWW::Mechanize Movable Type hack example
# this example prompts for the title and the body text

my $mech = WWW::Mechanize->new();
my %entry;
$entry->{title} =  &prompt_for_entry_title();
$entry->{btext} =  &prompt_for_entry_text();
my $server = qq|http://www.multiply.org|;
my $start = qq|/mt/mt.cgi|;

$mech->get($server . $start);
$mech->field('username','command line jason');
$mech->field('password','****');
$mech->submit(); # to get login cookie
$mech->get(qq|$start?__mode=view&_type=entry&blog_id=2|); # adjust as needed
$mech->form('entry_form');
$mech->field('title',$entry->{title});
$mech->field('category_id',7); # adjust as needed
$mech->field('text',$entry->{btext});
$mech->field('status',2); # 2 = publish, or 1 = draft

print "Thanks.\n----------------------------------\n";
print "Submitting entry...\n";
$results = $mech->submit(); 


# this is where we have to veer away from the initial example a bit.
# if you have chosen to publish this entry AND you have pings, then you 
# will see 2 javascript redirects.  That is the stinky thing about MT.

if ($mech->success()) {
    # travel the rebuild redirect
    $results = $mech->get($results->{_headers}->{location});
    
    if ($results->{_content} =~ /<body onLoad="([^\"]+)"/is) {
	# do we have an onload redirect?  yes
	    my $js = $1;
	    $js =~ /\'([^']+)\'/;
	    # this returns something like: 
	    #	window.location='/mt/mt.cgi?__mode=rebuild&blog_id=2&type=entry-214&next=0&offset=&limit=&total_entries=&is_bm=&entry_id=214&is_new=1&old_status=0'

	    print "Rebuilding...\n";
	    $results = $mech->get($server.$1);
	    $mech->submit();

	    if ($mech->success()) {
		    if ($results->{_content} =~ /<body onLoad="([^\"]+)"/is) {				
			# follow the ping redirect
		    	my $js = $1;
			$js =~ /\'([^']+)\'/;
			# this returns something like: 
			# window.location='/mt/mt.cgi?__mode=ping&blog_id=2&entry_id=218&is_new=1&old_status=0&is_bm='

		    	print "Sending out pings...\n";
		    	$results = $mech->get($server.$1);
		    	$mech->submit();
		     }
		}
	}
}


sub prompt_for_entry_text() {
	print "Please enter the text for your post:\n";
	print "\t--- end your post with period alone on a line\n";

	my $input;
	while (<>) {
		chomp ($_);
		last if ($_ eq ".");

		# append to our entry body
		$input .= "$_\n";
	}

	return $input;
}

sub prompt_for_entry_title() {
	print "Please enter the title for your post:\n";
	my $title;
	chomp ($title = <STDIN>);
	return $title;
}
